<script>
  const countdownEl = document.getElementById("countdown");

  // Set countdown duration: 11 hours, 15 minutes, 32 seconds
  const countdownDuration = 11 * 60 * 60 + 15 * 60 + 32; // total seconds
  let targetTime = Date.now() + countdownDuration * 1000;

  function updateCountdown() {
    const now = Date.now();
    const remaining = Math.max(0, Math.floor((targetTime - now) / 1000));

    const hours = String(Math.floor(remaining / 3600)).padStart(2, '0');
    const minutes = String(Math.floor((remaining % 3600) / 60)).padStart(2, '0');
    const seconds = String(remaining % 60).padStart(2, '0');

    countdownEl.textContent = `${hours}:${minutes}:${seconds}`;
  }

  updateCountdown(); // initial
  setInterval(updateCountdown, 1000);
</script>
